# AI + Cursor 开发一个模拟面试系统

## 开发过程直播回放

点击观看：[直播教程回放](https://www.codefather.cn/live/1904450818464538626)

## 需求分析

整个网站做的生动一些，多加一些搞笑的元素和小动画，营造出一种【面试光荣榜】的感觉

1）创建模拟面试的报告：可以输入候选人姓名、情况（年级 / 工作经验）、当前薪资、学习方向（比如 Java）、挑战薪资（比如月薪 15k）等

2）点击报告后，面试官可以录入模拟面试的问题（可以有多个问题）、并且针对每个问题录入候选人的回答、还可以给出这个回答的打分（0 ~ 100 分）。可以按照先后顺序展示这些问题，并且删除问题、在中间插入某个问题等。要能够实时地展示出当前的分数，并且根据分数给出一些文案（比如鼓励候选人）。

3）面试官可以主动结束这场面试，录入面试总结和建议，给出面试结果（比如是否通过、实际可以拿到的薪资等），并且生成完整的报告，展示出候选人的情况和面试官录入的所有信息

4）前端可以存储所有的面试报告，关闭浏览器之后也不会丢失

5）可以在主页创建报告、或者筛选出往期的所有报告

6）增加一个排行榜功能，按照实际可以拿到的薪资进行排名

## 输入给 AI 的提示词

技巧：当你能够运行项目之后，建议一个功能一个功能地修正

~~~markdown
▼markdown

复制代码### **需求文档：模拟面试光荣榜网站**

---

#### **1. 项目背景**
为了帮助候选人更好地准备面试，同时增加趣味性和互动性，我们计划开发一个 **模拟面试光荣榜网站**。该网站将模拟真实面试场景，记录面试过程，生成面试报告，并通过生动有趣的动画和文案，营造出一种“面试光荣榜”的氛围，激励候选人不断提升自己。

---

#### **2. 核心功能**

##### **2.1 创建模拟面试报告**
- **输入候选人信息**：
  - 姓名
  - 情况（年级 / 工作经验）
  - 当前薪资
  - 学习方向（如 Java、前端、数据分析等）
  - 挑战薪资（如月薪 15k）
- **动态效果**：
  - 输入信息后，页面弹出一个小动画（如候选人头像从屏幕外飞入，并附带一句搞笑文案：“这位勇士，准备好挑战高薪了吗？”）。

##### **2.2 模拟面试过程**
- **问题录入**：
  - 面试官可以录入多个面试问题，并按照顺序展示。
  - 支持在任意位置插入新问题、删除问题或调整问题顺序。
- **回答与打分**：
  - 针对每个问题，面试官可以录入候选人的回答，并给出打分（0 ~ 100 分）。
  - **实时展示当前平均分**：
    - 动态分数条实时显示当前所有问题的平均分数。
    - 根据平均分动态显示鼓励文案：
      - 平均分 < 60： “别灰心，再接再厉！💪”
      - 60 ≤ 平均分 < 80： “不错哦，离高薪更近一步了！🚀”
      - 平均分 ≥ 80： “哇塞，你就是未来的高薪大佬！🌟”
  - **动态效果**：
    - 每次打分后，分数条动态更新，伴随动画（如分数条平滑增长、烟花特效等）。
    - 当平均分达到某个里程碑（如 60、80、100 分）时，页面弹出搞笑动画（如候选人头像戴上墨镜，背景播放庆祝音效）。

##### **2.3 结束面试并生成报告**
- **面试总结与建议**：
  - 面试官可以录入面试总结和建议。
  - 给出面试结果（如是否通过、实际可以拿到的薪资等）。
- **生成完整报告**：
  - 展示候选人信息、面试问题、回答、打分、总结和建议。
  - 报告页面设计成“光荣榜”风格，附带搞笑动画（如候选人头像戴上皇冠，背景撒花）。
- **动态效果**：
  - 报告生成时，页面弹出动画（如“恭喜你完成挑战！”字样从屏幕底部升起）。

##### **2.4 数据存储与持久化**
- **本地存储**：
  - 使用 `localStorage` 或 `IndexedDB` 存储所有面试报告，关闭浏览器后数据不会丢失。
- **报告管理**：
  - 支持在主页创建新报告，或筛选查看往期报告。
  - 报告列表设计成“光荣榜”样式，附带候选人头像和搞笑标签（如“Java 大神”、“前端新星”）。

##### **2.5 排行榜功能**
- **薪资排名**：
  - 按照候选人实际可以拿到的薪资进行排名。
  - 排行榜页面设计成“光荣榜”风格，附带动态效果（如前三名头像显示奖杯动画）。
- **搞笑文案**：
  - 根据排名显示不同文案：
    - 第一名： “王者归来，无人能敌！👑”
    - 第二名： “离巅峰只差一步，继续加油！🔥”
    - 第三名： “稳坐前三，实力不容小觑！💎”

---

#### **3. 页面设计与交互**

##### **3.1 主页**
- **功能**：
  - 创建新报告按钮。
  - 往期报告筛选与查看。
  - 排行榜入口。
- **设计风格**：
  - 背景设计成“光荣榜”样式，附带动态元素（如飘动的彩带、闪烁的星星）。
  - 点击按钮时，弹出搞笑动画（如按钮变成火箭升空）。

##### **3.2 面试报告页面**
- **功能**：
  - 展示候选人信息、面试问题、回答、打分、总结和建议。
- **设计风格**：
  - 页面顶部显示候选人头像和搞笑标签（如“Java 挑战者”）。
  - 动态分数条实时展示当前平均分，分数变化时伴随动画和鼓励文案。

##### **3.3 排行榜页面**
- **功能**：
  - 展示候选人薪资排名。
- **设计风格**：
  - 设计成“光荣榜”样式，附带动态效果（如前三名头像显示奖杯动画）。
  - 鼠标悬停时，显示候选人详细信息。

---

#### **4. 技术实现**

##### **4.1 前端**
- **框架**：React 或 Vue.js。
- **动画库**：使用 GSAP 或 Anime.js 实现搞笑动画。
- **本地存储**：使用 `localStorage` 或 `IndexedDB` 存储数据。

##### **4.2 后端（可选）**
- 如果需要支持多用户或数据同步，可以使用 Node.js + Express 或 Firebase。

##### **4.3 数据存储**
- **数据结构示例**：
  ```json
  {
    "id": "12345",
    "name": "张三",
    "experience": "应届生",
    "currentSalary": "8k",
    "targetSalary": "15k",
    "questions": [
      {
        "question": "请介绍一下 Java 的垃圾回收机制。",
        "answer": "Java 的垃圾回收机制是通过 JVM 自动管理内存...",
        "score": 85
      }
    ],
    "averageScore": 85,
    "summary": "表现优秀，基础扎实，建议加强项目经验。",
    "result": "通过",
    "finalSalary": "13k"
  }


#### **5. 预期效果**
- **趣味性**：通过搞笑动画和文案，让候选人感受到轻松愉快的面试氛围。
- **实用性**：通过详细的面试报告和排行榜功能，帮助候选人了解自身水平，明确提升方向。
- **互动性**：通过动态分数展示和鼓励文案，增强候选人的参与感和成就感。
~~~

---

加入编程导航，获取 10+ 套原创企业级实战项目，可以直接写进简历：

https://yuyuanweb.feishu.cn/wiki/VC1qwmX9diCBK3kidyec74vFnde
